# Thanks to SuperDave who made that pickle thread which syntax is pretty much the same as cPickle
# Again thanks to SuperDave who made the escapelib, it was a great help
# Again, thanks to SuperDave who helped with some nub errors I made

import es, cPickle, os.path, playerlib, popuplib, bbank_config
from bbank_config import *

player_data = {}

info = es.AddonInfo() 
info['name']        = "BBank" 
info['version']     = "1.0" 
info['author']      = "Bonbon AKA: Bonbon367" 
info['url']         = "http://www.notimplementedyet.com" 
info['description'] = "A new bank with lots of added features" 

first_round = 0

def load():
	if not es.exists('saycommand', '!bank'):
		es.regsaycmd('!bank', 'bbank/showmenu', 'Show the main bank menu')
	if not es.exists('saycommand', '!deposit'):
		es.regsaycmd('!deposit', 'bbank/deposit', 'Easy deposit')
	if not es.exists('saycommand', '!withdraw'):
		es.regsaycmd('!withdraw', 'bbank/withdraw', 'Easy withdrawal')
	if not es.exists('saycommand', '!badmin'):
		es.regsaycmd('!badmin', 'bbank/admin', 'Admin Command')
	if not es.exists('clientcommand', 'cash'):
		es.regclientcmd('cash','bbank/givecash') 
	if not es.exists('saycommand', 'bank'):
		es.regsaycmd('bank', 'bbank/showmenu', 'Show the main bank menu')
	if not es.exists('saycommand', 'deposit'):
		es.regsaycmd('deposit', 'bbank/deposit', 'Easy deposit')
	if not es.exists('saycommand', 'withdraw'):
		es.regsaycmd('withdraw', 'bbank/withdraw', 'Easy withdrawal')
	if not es.exists('saycommand', 'transfer'):
		es.regsaycmd('transfer', 'bbank/transfer', 'Easy transfer')
	if not es.exists('saycommand', 'give'):
		es.regsaycmd('give', 'bbank/transfer', 'Easy transfer')
	mainmenu = popuplib.easymenu('BBank', '_popup_choice', main_menu_select)
	depositmenu = popuplib.easymenu('Deposit', '_popup_choice', deposit_select)
	withdrawmenu = popuplib.easymenu('Withdraw', '_popup_choice', withdraw_select)
	transfermenu = popuplib.easymenu('Transfer', '_popup_choice', transfer_select)
	adminmenu = popuplib.easymenu('Admin Menu', '_popup_choice', admin_select)
	playerinfo = popuplib.easymenu('Player Info', '_popup_choice', pinfo_select)
	adminmenu.addoption('Give/Take Cash', 'Give/Take Cash')
	adminmenu.addoption('Reset', 'Reset BBank')
	confirmmenu = popuplib.easymenu('Are You Sure?', '_popup_choice', confirm_reset)
	confirmmenu.addoption('Yes', 'Yes')
	confirmmenu.addoption('No', 'No')
	depositmenu.addoption('all', 'all')
	withdrawmenu.addoption('all', 'all')
	for b in ('1000', '2000', '4000', '8000', '10000', '14000'):
		depositmenu.addoption(b, b)
		withdrawmenu.addoption(b, b)
	mainmenu.addoption('Show Balance', 'Show Balance')
	mainmenu.addoption('Transfer', 'Transfer')
	mainmenu.addoption('Deposit', 'Deposit')
	mainmenu.addoption('Withdraw', 'Withdraw')
	mainmenu.addoption('Top', 'Top')
	mainmenu.addoption('Player Info', 'Player Info')
	depositmenu.submenu(0, 'BBank')
	withdrawmenu.submenu(0, 'BBank')
	player_db = es.getAddonPath('bbank') + '/player_info.db'
	if os.path.isfile(player_db):
		global player_data
		player_cash = open(player_db)
		player_data = cPickle.load(player_cash)
		player_cash.close()
	es.msg('#multi', '%sLoaded - Made by Bonbon: AKA Bonbon367'%tell_format)

def unload():
	if es.exists('saycommand', '!bank'):
		es.unregsaycmd('!bank')
	if es.exists('saycommand', '!deposit'):
		es.unregsaycmd('!deposit')
	if es.exists('saycommand', '!withdraw'):
		es.unregsaycmd('!withdraw')
	if es.exists('saycommand', '!badmin'):
		es.unregsaycmd('!badmin')
	if es.exists('clientcommand', 'cash'):
		es.unregclientcmd('cash')
	if es.exists('saycommand', 'bank'):
		es.unregsaycmd('bank')
	if es.exists('saycommand', 'deposit'):
		es.unregsaycmd('deposit')
	if es.exists('saycommand', 'withdraw'):
		es.unregsaycmd('withdraw')
	if es.exists('saycommand', 'transfer'):
		es.unregsaycmd('transfer')
	if es.exists('saycommand', 'give'):
		es.unregsaycmd('give')
	save_data()
	es.msg('#multi', '%sUnloaded - Made by Bonbon: AKA Bonbon367'%tell_format)

def player_activate(ev):
	steamid = ev['es_steamid']
	if player_data.has_key(steamid):
		global player_data
		bank(ev['userid'], ev['es_steamid']).intrest('player_activate', 'coming back to the server')
		player_data[steamid]['name'] = ev['es_username']

def es_map_start(ev):
	global player_data
	for userid in playerlib.getUseridList('#all'):
		player_data[playerlib.getPlayer(userid).get('steamid')]['cash'] *= intrest_rates['map_change']

def round_end(ev):
	global player_data
	save_data()
	for userid in playerlib.getUseridList('#all'): 
		bank(userid, playerlib.getPlayer(userid).get('steamid')).intrest('round_end', 'the round ending')
	if ev['winner'] == '2': filter = '#t'
	elif ev['winner'] == '3': filter = '#ct'
	for userid in playerlib.getUseridList(filter):
		bank(userid, playerlib.getPlayer(userid).get('steamid')).intrest('round_won', 'winning the round')
	for userid in playerlib.getUseridList('%s,#alive'%filter):
		bank(userid, playerlib.getPlayer(userid).get('steamid')).intrest('round_survived', 'surviving the round')
	if first_round == 0:
		global first_round
		first_round = 1

def bomb_defused(ev):
	bank(ev['userid'], ev['es_steamid']).intrest('bomb_defuse', 'defusing the bomb')

def bomb_planted(ev):
	bank(ev['userid'], ev['es_steamid']).intrest('bomb_plant', 'planting the bomb')

def bomb_exploded(ev):
	bank(ev['userid'], ev['es_steamid']).intrest('bomb_explode', 'the bomb exploding')

def hostage_rescued(ev):
	bank(ev['userid'], ev['es_steamid']).intrest('hostage_rescue', 'rescuing a hostage')

def round_start(ev):
	global player_data
	for a in playerlib.getUseridList('#all'):
		player_data[playerlib.getPlayer(a).get('steamid')]['withdraws'] = 0

class bank:
	def __init__(self, userid, steamid):
		self.userid = userid
		self.steamid = steamid

	def deposit(self, amount):
		global player_data
		if self.steamid != 'BOT':
			player_data[self.steamid]['cash'] += int(amount)
			playerlib.getPlayer(self.userid).set('cash', int(playerlib.getPlayer(self.userid).get('cash')) - int(amount))
			es.tell(self.userid, '#multi', '%sYou have deposited #lightgreen%s #green into the bank you now have #lightgreen%s'%(tell_format, amount, int(player_data[self.steamid]['cash'])))

	def transfer(self, target_userid, target_steamid, amount):
		global player_data
		if self.steamid != 'BOT' and target_steamid != 'BOT':
			if amount > 0 and amount <= player_data[self.steamid]['cash']:
				player_data[self.steamid]['cash'] -= amount
				player_data[target_steamid]['cash'] += amount
				es.tell(target_userid, '#multi', '%sYou have recieved #lightgreen%s #greendollars into your account from %s'%(tell_format, amount, playerlib.getPlayer(self.userid).attributes['name']))
				es.tell(self.userid, '#multi', '%sYou have sent #lightgreen%s #greendollars to %s'%(tell_format, amount, playerlib.getPlayer(target_userid).attributes['name']))

	def withdraw(self, amount):
		global player_data
		if self.steamid != 'BOT':
			if first_round == 1 or enable_withdraw_on_first_round == 1:
				if player_data[self.steamid]['withdraws'] < max_withdraws_per_round or max_withdraws_per_round == 0:
					if playerlib.getPlayer(self.userid).get('cash') + int(amount) <= 16000:
						player_data[self.steamid]['cash'] -= int(amount)
						playerlib.getPlayer(self.userid).set('cash', int(playerlib.getPlayer(self.userid).get('cash')) + int(amount))
						player_data[self.steamid]['withdraws'] += 1
						es.tell(self.userid, '#multi', '%sYou have withdrawn #lightgreen%s#green dollars from the bank and have #lightgreen%s #green remaining'%(tell_format, amount, int(player_data[self.steamid]['cash'])))
					else:
						es.tell(self.userid, '#multi', '%sYou cannot have more than $16000!'%tell_format)
				else:
					es.tell(self.userid, '#multi', '%sYou do not have any withdraws left!'%tell_format)
			else:
				es.tell(self.userid, '#multi', '%sYou cannot withdraw on the first round!'%tell_format)

	def intrest(self, event, message):
		global player_data
		if self.steamid != 'BOT':
			player_data[self.steamid]['cash'] *= 1 + intrest_rates[event]
			if player_data[self.steamid]['cash'] * intrest_rates[event] > 5:
				es.tell(self.userid, '#multi', '%sYou have gained #lightgreen%s #greenintrest for %s'%(tell_format, int(player_data[self.steamid]['cash'] * intrest_rates[event]), message))


def checkcash(userid, amount):
		if playerlib.getPlayer(userid).get('cash') >= amount:
			return 1
		else:
			return 0

def showmenu():
	global player_data
	userid = es.getcmduserid()
	steamid = playerlib.getPlayer(userid).get('steamid')
	popuplib.send('BBank', userid)
	if not player_data.has_key(steamid):
		player_data[steamid] = {}
		player_data[steamid]['cash'] = start_cash
		player_data[steamid]['name'] = playerlib.getPlayer(userid).attributes['name']
		player_data[steamid]['withdraws'] = 0
		es.tell(userid, '#multi', '%sAccount Created'%tell_format)

def deposit():
	userid = es.getcmduserid()
	steamid = playerlib.getPlayer(userid).get('steamid')
	amount = es.getargv(1)
	if es.getargc() >= 2:
		if amount == 'all':
			amount = playerlib.getPlayer(userid).get('cash')
		else:
			amount = int(amount)
		if checkcash(userid, amount):
			bank(userid, steamid).deposit(amount)
		else:
			es.tell(userid, '#multi', '%sYou do not have #lightgreen%s #greento deposit!'%(tell_format, amount))
	else:
		popuplib.send('Deposit', userid)

def withdraw():
	userid = es.getcmduserid()
	steamid = playerlib.getPlayer(userid).get('steamid')
	amount = es.getargv(1)
	if es.getargc() >= 2:
		if amount == 'all':
			if player_data[steamid]['cash'] >= 16000 - int(playerlib.getPlayer(userid).get('cash')):
				amount = 16000 - int(playerlib.getPlayer(userid).get('cash'))
			else:
				amount = player_data[steamid]['cash']
		else:
			amount = int(amount)
		if player_data[steamid]['cash'] >= amount:
			bank(userid, steamid).withdraw(amount)
		else: 
			es.tell(userid, '#multi', '%sYou do not have #lightgreen%s #greento withdraw!'%(tell_format, amount))
	else:
		popuplib.send('Withdraw', userid)

def main_menu_select(userid, choice, popupid):
	if choice == 'Transfer':
		transfermenu = popuplib.easymenu('Transfer', '_popup_choice', transfer_select)
		for userid2 in playerlib.getUseridList('#all'):
			transfermenu.addoption(userid2, playerlib.getPlayer(userid2).attributes['name'])
	elif choice == 'Show Balance':
		es.tell(userid, '#multi', '%sYou have #lightgreen%s #greenin the bank'%(tell_format, int(player_data[playerlib.getPlayer(userid).get('steamid')]['cash'])))
	elif choice == 'Top':
		t___t = players_in_top
		top = popuplib.easymenu('Top', '_popup_choice', top_select)
		for k in asort(player_data):
			if t___t > 0:
				t___t -= 1
				top.addoption(k, '%s: %s'%(player_data[k]['name'], int(player_data[k]['cash'])))
	elif choice == 'Player Info':
		playerinfo = popuplib.easymenu('Player Info', '_popup_choice', pinfo_select)
		for userid2 in playerlib.getUseridList('#all'):
			playerinfo.addoption(userid2, playerlib.getPlayer(userid2).attributes['name'])
	popuplib.send(choice, userid)

def deposit_select(userid, choice, popupid):
	if choice == 'all':
		amount = int(playerlib.getPlayer(userid).get('cash'))
	else:
		amount = int(choice)
	if checkcash(userid, amount):
		bank(userid, playerlib.getPlayer(userid).get('steamid')).deposit(amount)

def withdraw_select(userid, choice, popupid):
	if choice == 'all':
		amount = 16000 - int(playerlib.getPlayer(userid).get('cash'))
	else:
		amount = int(choice)
	if player_data[playerlib.getPlayer(userid).get('steamid')]['cash'] >= amount:
		bank(userid, playerlib.getPlayer(userid).get('steamid')).withdraw(amount)
	else:
		es.tell(userid, '#multi', '%sYou do not have #lightgreen%s #greento withdraw!'%(tell_format, amount))

def transfer_select(userid, choice, popupid):
	transfermenu2 = popuplib.easymenu('Transfer Amount', '_popup_choice', transfer_select2)
	for a in ('all', '1000', '2000', '4000', '8000', '16000', '20000', '40000'):
		transfermenu2.addoption((choice, a), a)
	popuplib.send('Transfer Amount', userid)

def transfer_select2(userid, choice, popupid):
	steamid = playerlib.getPlayer(userid).get('steamid')
	target_steamid = playerlib.getPlayer(choice[0]).get('steamid')
	amount = choice[1]
	if amount == 'all':
		amount = player_data[steamid]['cash']
	else:
		amount = int(amount)
	if player_data[steamid]['cash'] >= amount:
		bank(userid, steamid).transfer(choice[0], target_steamid, amount)
	else: 
		es.tell(userid, '#multi', '%sYou do not have #lightgreen%s #greento transfer!'%(tell_format, amount))

def asort(player_data): # Google's your friend
	rev_items = [(v, k) for k, v in player_data.items()]
	rev_items.sort(reverse=True)
	return [k for (v, k) in rev_items]

def top_select(userid, choice, popupid):
	es.tell(userid, '#multi', '%sSteamID - %s Cash - %s, Last Known Name - %s'%(tell_format, choice, player_data[choice]['cash'], player_data[choice]['name']))

def save_data():
	player_db = open(es.getAddonPath('bbank') + '/player_info.db', 'w')
	cPickle.dump(player_data, player_db)
	player_db.close()

def admin():
	userid = es.getcmduserid()
	steamid = playerlib.getPlayer(userid).get('steamid')
	if steamid in admins:
		if player_data.has_key(steamid):
			popuplib.send('Admin Menu', userid)
		else:
			es.tell(userid, '#multi', '%sPlease create an account first by typing #lightgreen!bank'%tell_format)


def admin_select(userid, choice, popupid):
	if choice == 'Give/Take Cash':
		admintake = popuplib.easymenu('Give/Take Cash', '_popup_choice', admingive_select)
		for userid2 in playerlib.getUseridList('#all'):
			admintake.addoption(userid2, playerlib.getPlayer(userid2).attributes['name'])
		popuplib.send('Give/Take Cash', userid)
	elif choice == 'Reset':
		popuplib.send('Are You Sure?', userid)

def admingive_select(userid, choice, popupid):
	global player_data
	es.escinputbox(30, userid, '|-BBank Give/Take Cash-|', 'Please Input a value to Give/Take', 'cash')
	player_data[playerlib.getPlayer(userid).get('steamid')]['target'] = choice
	es.tell(userid, '#multi', '%sPress escape on your keyboard to input a value'%tell_format)

def givecash():
	userid = es.getcmduserid()
	amount = int(es.getargv(1))
	global player_data
	if playerlib.getPlayer(userid).get('steamid') in admins:
		if player_data[playerlib.getPlayer(userid).get('steamid')].has_key('target'):
			if player_data[playerlib.getPlayer(player_data[playerlib.getPlayer(userid).get('steamid')]['target']).get('steamid')]['cash'] + amount >= 0:
				player_data[playerlib.getPlayer(player_data[playerlib.getPlayer(userid).get('steamid')]['target']).get('steamid')]['cash'] += amount
				if amount > 0:
					es.tell(player_data[playerlib.getPlayer(userid).get('steamid')]['target'], '#multi', '%sAn admin has Given #lightgreen%s #greencash too you'%(tell_format, amount))
				else:
					es.tell(player_data[playerlib.getPlayer(userid).get('steamid')]['target'], '#multi', '%sAn admin has Taken #lightgreen%s #greencash from you'%(tell_format, -amount))
			else:
				es.tell(userid, '#multi', '%sSorry, that person does not have enough cash for you to take #lightgreen%s'%(tell_format, amount))
		else:
			es.tell(userid, '#multi', '%sPlease select a target!'%tell_format)
	else:
		es.tell(userid, '#multi', '%sSorry, you are not authorized to run this command!'%tell_format)

def pinfo_select(userid, choice, popupid):
	steamid = playerlib.getPlayer(choice).get('steamid')
	es.tell(userid, '#multi', '%sSteamID - #lightgreen%s Cash - %s, #greenLast Known Name - %s'%(tell_format, steamid, int(player_data[steamid]['cash']), player_data[steamid]['name']))

def confirm_reset(userid, choice, popupid):
	global player_data
	if choice == 'Yes':
		player_data.clear()

def transfer():
	userid = es.getcmduserid()
	target = es.getuserid(es.getargv(1))
	amount = es.getargv(2)
	if amount == 'all':
		amount = int(player_data[playerlib.getPlayer(userid).get('steamid')]['cash'])
	else:
		amount = int(amount)
	if target:
		bank(userid, playerlib.getPlayer(userid).get('steamid')).transfer(target, playerlib.getPlayer(target).get('steamid'), amount)
	else:
		es.tell(userid, '#multi', '%sInvalid player'%tell_format)