# ./addons/eventscripts/sourceradio.py

import es, cfglib, popuplib, usermsg, gamethread

config = cfglib.AddonCFG(es.getAddonPath("sourceradio") + "/sourceradio.cfg")
radio_advert            = config.cvar('radio_advert', 1, 'do you want to advertise that your server uses this addon? 1 = yes, 0 = no')
radio_rounds_tilladvert = config.cvar('radio_rounds_tilladvert', 1, '1 = every round displays advert, 2 = advert displays every other round, etc.')
config.write()

info = es.AddonInfo()
info['name']        = "Source Radio"
info['version']     = "1.5"
info['author']      = "digital spanky"
info['url']         = "http://addons.eventscripts.com/addons/view/sourceradio"
info['description'] = "In-game radio using SourceTunes.com and Mattie's ES"

es.ServerVar('sourceradio_version', info['version'], 'Source Radio made by digital spanky').makepublic()

def load():
   config.execute()
   global roundcount
   roundcount = 0
   index = popuplib.create('index')
   index.addline('Source Radio')
   index.addline('->1. Browse Source Tunes')
   index.addline('->2. Blues/Jazz')
   index.addline('->3. Country')
   index.addline('->4. Dance/Techno/House')
   index.addline('->5. Hit Music')
   index.addline('->6. Old School/Decades')
   index.addline('->7. Rock')
   index.addline('->8. Urban/RnB')
   index.addline('->9. World/Latin')
   index.addline(' ')
   index.addline('->0. Exit')
   index.menuselect = index_menu
   
   jazz = popuplib.create('jazz')
   jazz.addline('Blues/Jazz')
   jazz.addline("->1. Bar Rockin' Blues")
   jazz.addline('->2. Cajun Fest')
   jazz.addline('->3. Classic Blues')
   jazz.addline('->4. Smooth Jazz')
   jazz.addline('->5. Big Band Cantina')
   jazz.addline(' ')
   jazz.addline('->8. Previous Page')
   jazz.addline('0. Exit')
   jazz.menuselect = jazz_menu
   
   country = popuplib.create('country')
   country.addline('Country')
   country.addline("->1. Bar Rockin' Country")
   country.addline('->2. Classic Country')
   country.addline('->3. Folk Classics')
   country.addline('->4. Hit Kicker Country')
   country.addline('->5. Ladies of Country')
   country.addline("->6. Tears N' Beers Country")
   country.addline(' ')
   country.addline('->8. Previous Page')
   country.addline('0. Exit')
   country.menuselect = country_menu
   
   dance = popuplib.create('dance')
   dance.addline('Dance/Techno/House')
   dance.addline('->1. Dance Hits (Chicago)')
   dance.addline('->2. 93.1 The Beat (Miami)')
   dance.addline('->3. House (Miami)')
   dance.addline('->4. Chicago House Radio')
   dance.addline('->5. Trance')
   dance.addline('->6. Breakbeat (Tampa)')
   dance.addline('->7. Trance and Progressive')
   dance.addline(' ')
   dance.addline('->8. Previous Page')
   dance.addline('->9. Next Page')
   dance.addline('0. Exit')
   dance.menuselect = dance_menu
   
   dance2 = popuplib.create('dance2')
   dance2.addline('Dance/Techno/House')
   dance2.addline('->1. Electronic Playground')
   dance2.addline('->2. Drum and Bass')
   dance2.addline('->3. Industrial Radio')
   dance2.addline(' ')
   dance2.addline('->8. Previous Page')
   dance2.addline('0. Exit')
   dance2.menuselect = dance2_menu
   
   hits = popuplib.create('hits')
   hits.addline('Hit Music')
   hits.addline('->1. Top 40')
   hits.addline('->2. 95 The Lite')
   hits.addline('->3. At Work Radio')
   hits.addline('->4. Hard Rock')
   hits.addline('->5. Rhythmic Hits')
   hits.addline('->6. Alternative Rock')
   hits.addline('->7. Mix 106 - 90s and Now!')
   hits.addline(' ')
   hits.addline('->8. Previous Page')
   hits.addline('->9. Next Page')
   hits.addline('0. Exit')
   hits.menuselect = hits_menu
   
   hits2 = popuplib.create('hits2')
   hits2.addline('Hit Music')
   hits2.addline('->1. RnB Hits ')
   hits2.addline('->2. Hot 101.5 (Dance and Pop)')
   hits2.addline(' ')
   hits2.addline('->8. Previous Page')
   hits2.addline('0. Exit')
   hits2.menuselect = hits2_menu
   
   decades = popuplib.create('decades')
   decades.addline('Old School/Decades')
   decades.addline('->1. Disco (Studio 54)')
   decades.addline("->2. Jammin' Oldies")
   decades.addline('->3. 90s Dance Hits')
   decades.addline('->4. Old School Funk')
   decades.addline("->5. Skatin' Jamz")
   decades.addline('->6. 80s Hi-NRG Dance')
   decades.addline('->7. 70s Lite Hits')
   decades.addline(' ')
   decades.addline('->8. Previous Page')
   decades.addline('->9. Next Page')
   decades.addline('0. Exit')
   decades.menuselect = decades_menu
   
   decades2 = popuplib.create('decades2')
   decades2.addline('Old School/Decades')
   decades2.addline('->1. 80s Lite Hits')
   decades2.addline('->2. 70s Decade - Pop')
   decades2.addline('->3. 80s Decade - Pop')
   decades2.addline('->4. 90s Decade - Rhythmic')
   decades2.addline('->5. 90s Decade - Pop')
   decades2.addline(' ')
   decades2.addline('->8. Previous Page')
   decades2.addline('0. Exit')
   decades2.menuselect = decades2_menu
   
   rock = popuplib.create('rock')
   rock.addline('Rock')
   rock.addline('->1. Hard Rock')
   rock.addline('->2. Alternative Rock')
   rock.addline('->3. Classic Rock')
   rock.addline('->4. Hair Voltage')
   rock.addline('->5. Love Bites')
   rock.addline('->6. Classic Alternative')
   rock.addline('->7. Classic New Wave')
   rock.addline(' ')
   rock.addline('->8. Previous Page')
   rock.addline('->9. Next Page')
   rock.addline('0. Exit')
   rock.menuselect = rock_menu
   
   rock2 = popuplib.create('rock2')
   rock2.addline('Rock')
   rock2.addline('->1. Heavy Metal')
   rock2.addline(' ')
   rock2.addline('->8. Previous Page')
   rock2.addline('0. Exit')
   rock2.menuselect = rock2_menu
   
   urban = popuplib.create('urban')
   urban.addline('Urban/RnB')
   urban.addline('->1. RnB Hits')
   urban.addline('->2. Rhythmic Hits')
   urban.addline('->3. Quiet Storm')
   urban.addline('->4. Great Golden Grooves')
   urban.addline('->5. Solid Gold Soul')
   urban.addline('->6. Old School Funk')
   urban.addline("->7. Jammin' Oldies")
   urban.addline(' ')
   urban.addline('->8. Previous Page')
   urban.addline('->9. Next Page')
   urban.addline('0. Exit')
   urban.menuselect = urban_menu
   
   urban2 = popuplib.create('urban2')
   urban2.addline('Urban/RnB')
   urban2.addline('->1. The Flava - CLEAN')
   urban2.addline('->2. The Flava - RAW')
   urban2.addline('->3. Old School Rap')
   urban2.addline("->4. Skatin' Jamz")
   urban2.addline(' ')
   urban2.addline('->8. Previous Page')
   urban2.addline('0. Exit')
   urban2.menuselect = urban2_menu
   
   world = popuplib.create('world')
   world.addline('World/Latin')
   world.addline('->1. Latino Caliente')
   world.addline('->2. Reggaeton')
   world.addline('->3. Merengue')
   world.addline('->4. Salsa')
   world.addline(' ')
   world.addline('->8. Previous Page')
   world.addline('0. Exit')
   world.menuselect = world_menu
   
def unload():
   popuplib.delete('index')
   popuplib.delete('jazz')
   popuplib.delete('country')
   popuplib.delete('dance')
   popuplib.delete('dance2')
   popuplib.delete('hits')
   popuplib.delete('hits2')
   popuplib.delete('decades')
   popuplib.delete('decades2')
   popuplib.delete('rock')
   popuplib.delete('rock2')
   popuplib.delete('urban')
   popuplib.delete('urban2')
   popuplib.delete('world')
   
def index_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes', 'http://www.sourcetunes.com/players/server_player/radio.php?id=css')
   elif choice == 2:
      popuplib.send('jazz', userid)
   elif choice == 3:
      popuplib.send('country', userid)
   elif choice == 4:
      popuplib.send('dance', userid)
   elif choice == 5:
      popuplib.send('hits', userid)
   elif choice == 6:
      popuplib.send('decades', userid)
   elif choice == 7:
      popuplib.send('rock', userid)
   elif choice == 8:
      popuplib.send('urban', userid)
   elif choice == 9:
      popuplib.send('world', userid)
   
def jazz_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Blues/Jazz', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=barrockinblues')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Blues/Jazz', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=cajunfest')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Blues/Jazz', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=classicblues')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - Blues/Jazz', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=smoothjazz')
   elif choice == 5:
      usermsg.motd(userid, 2, 'Source Tunes - Blues/Jazz', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=%20bigbandcantina')
   elif choice == 6:
      usermsg.motd(userid, 2, 'Source Tunes - Blues/Jazz', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=jazzmasters')
   elif choice == 8:
      popuplib.close('jazz', userid)
      popuplib.send('index', userid)
   
def country_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Country', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=barrockincountry')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Country', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=classiccountry')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Country', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=folkclassics')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - Country', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=hitkickercountry')
   elif choice == 5:
      usermsg.motd(userid, 2, 'Source Tunes - Country', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=ladiesofcountry')
   elif choice == 6:
      usermsg.motd(userid, 2, 'Source Tunes - Country', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=tearsnbeerscountry')
   elif choice == 8:
      popuplib.close('country', userid)
      popuplib.send('index', userid)
   
def dance_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=dancehitschicago')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=thebeatmiami')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=housemiami')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=chicagohouseradio')
   elif choice == 5:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=trance')
   elif choice == 6:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=breakbeattampa')
   elif choice == 7:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=tranceprogressive')
   elif choice == 8:
      popuplib.close('dance', userid)
      popuplib.send('index', userid)
   elif choice == 9:
      popuplib.close('dance', userid)
      popuplib.send('dance2', userid)
   
def dance2_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=electronicplayground')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=drumbass')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Dance/Techno/House', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=realindustrial')
   elif choice == 8:
      popuplib.close('dance2', userid)
      popuplib.send('dance', userid)
   
def hits_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Hit Music', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=top40')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Hit Music', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=95thelite')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Hit Music', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=atworkradio')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - Hit Music', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=Hard%20Rock')
   elif choice == 5:
      usermsg.motd(userid, 2, 'Source Tunes - Hit Music', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=rhythmichits')
   elif choice == 6:
      usermsg.motd(userid, 2, 'Source Tunes - Hit Music', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=alternativerock')
   elif choice == 7:
      usermsg.motd(userid, 2, 'Source Tunes - Hit Music', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=mix10690snow')
   elif choice == 8:
      popuplib.close('hits', userid)
      popuplib.send('index', userid)
   elif choice == 9:
      popuplib.close('hits', userid)
      popuplib.send('hits2', userid)
   
def hits2_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Hit Music', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=rbhits')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Hit Music', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=hot101')
   elif choice == 8:
      popuplib.close('hits2', userid)
      popuplib.send('hits', userid)
   
def decades_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=disco')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=jamminoldies')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=90sdancehits')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=oldschoolfunk')
   elif choice == 5:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=skatinjamz')
   elif choice == 6:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=%2080shinrgdance')
   elif choice == 7:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=70slitehits')
   elif choice == 8:
      popuplib.close('decades', userid)
      popuplib.send('index', userid)
   elif choice == 9:
      popuplib.close('decades', userid)
      popuplib.send('decades2', userid)
   
def decades2_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=80slitehits')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=70sdecade%20pop')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=80sdecadepop')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=90sdecaderhythmic')
   elif choice == 5:
      usermsg.motd(userid, 2, 'Source Tunes - Old School/Decades', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=90sdecadepop')
   elif choice == 8:
      popuplib.close('decades2', userid)
      popuplib.send('decades', userid)
   
def rock_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Rock', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=hardrock')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Rock', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=alternativerock')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Rock', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=classicrock')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - Rock', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=hairvoltage')
   elif choice == 5:
      usermsg.motd(userid, 2, 'Source Tunes - Rock', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=lovebites')
   elif choice == 6:
      usermsg.motd(userid, 2, 'Source Tunes - Rock', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=classicalternative')
   elif choice == 7:
      usermsg.motd(userid, 2, 'Source Tunes - Rock', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=classicnewwave')
   elif choice == 8:
      popuplib.close('rock', userid)
      popuplib.send('index', userid)
   elif choice == 9:
      popuplib.close('rock', userid)
      popuplib.send('rock2', userid)
   
def rock2_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Rock', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=heavymetal')
   elif choice == 8:
      popuplib.close('rock2', userid)
      popuplib.send('rock', userid)

def urban_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=rbhits')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=rhythmichits')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=quietstorm')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=greatgoldengrooves')
   elif choice == 5:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=solidgoldsoul')
   elif choice == 6:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=oldschoolfunk')
   elif choice == 7:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=jamminoldies')
   elif choice == 8:
      popuplib.close('urban', userid)
      popuplib.send('index', userid)
   elif choice == 9:
      popuplib.close('urban', userid)
      popuplib.send('urban2', userid)
   
def urban2_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=thaflavaclean')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=thaflavaraw')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=oldschoolrap')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - Urban/RnB', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=skatinjamz')
   elif choice == 8:
      popuplib.close('urban2', userid)
      popuplib.send('urban', userid)
   
def world_menu(userid, choice, popupid):
   if choice == 1:
      usermsg.motd(userid, 2, 'Source Tunes - World/Latin', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=Latino%20Caliente')
   elif choice == 2:
      usermsg.motd(userid, 2, 'Source Tunes - World/Latin', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=Reggaeton')
   elif choice == 3:
      usermsg.motd(userid, 2, 'Source Tunes - World/Latin', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=Merengue')
   elif choice == 4:
      usermsg.motd(userid, 2, 'Source Tunes - World/Latin', 'http://www.sourcetunes.com/players/server_player/play.php?id=css&game=&chan=salsa')
   elif choice == 8:
      popuplib.close('world', userid)
      popuplib.send('index', userid)
   
def player_say(ev):
   if ev['text'].lower() in ('!radio', '/radio'):
      popuplib.send('index', ev['userid'])
   elif ev['text'].lower() in ('!radiooff', '/radiooff'):
      usermsg.motd(ev['userid'], 2, 'Source Tunes', 'http://www.sourcetunes.com/players/server_player/off.php?id=css')

def round_start(ev):
   global roundcount
   roundcount += 1
   if roundcount == radio_rounds_tilladvert:
      roundcount = 0
      if int(radio_advert):
         es.msg('#multi', '#green[#lightgreenSource Radio#green] #defaultType #lightgreen!radio #defaultto bring up the radio menu')
         es.msg('#multi', '#green[#lightgreenSource Radio#green] #defaultType #lightgreen!radiooff #defaultto switch the radio off')